# Performance Predictor

This folder includes everything related to running the CAE for feature maps and LSTM for performance prediction and NAP2 agent. It also includes the creation of feature maps from statistics files created by the Model Builder.


1) Creating Feature Maps - Create feature maps for multiple weights and gradient statistics files. Run the FeatureMap/FeatureMapDataCreator.py script with the following arguments:
	* -i <input statistics folder>
	* -o <maps output folder>
	* -p 1
	* -nan 0.1
	* -slurm -1
	* -weights <set to 1 for creating feature maps on weights, set to 0 for creating feature maps on gradients>

2) CAE Training - train a convolutional auto encoder on feature maps. Run the file: Encoder/AutoEncoderTraining.py with the following arguments:
	* --auto_encoder_struct 512 256 128 
	* -emb_size 128 
	* -vs <size of validation split from data>
	* -ts <size of validation split from training data>
	* -data <weights or gradients for selecting which data to train>
	* -s CAE save folder
	* -f <inpud folders with feature maps>

3) Train LSTM Performance Predictor - train LSTM model for performance prediction. Run the file: BaselineModel/BaselineLSTMTraining.py -m lstm_combined. The file has multiple arguments that you will be prompt about after running it for the first time. Just make sure to run with -m lstm_combined

4) Run NAP2 Agent - SelectionAgent/SelectionAgentRunner.py. The file has multiple arguments that you will be prompt about after running it for the first time.